IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'PDV_PONTOS_FIDEL_IT')
BEGIN
CREATE TABLE [dbo].[PDV_PONTOS_FIDEL_IT](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[ID_CAB] [bigint] NOT NULL,
	[CD_IT] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_TBL_FIDEL] [int] NOT NULL,
	[QT_PONTOS] [money] NOT NULL,
	[QT_PONTOS_ADICIONAIS] [money] NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

END
GO

IF NOT EXISTS (SELECT * FROM SYS.default_constraints WHERE NAME = 'DF_PDV_PONTOS_FIDEL_IT_QT_PONTOS_ADICIONAIS')
BEGIN
	ALTER TABLE [dbo].[PDV_PONTOS_FIDEL_IT] ADD  CONSTRAINT [DF_PDV_PONTOS_FIDEL_IT_QT_PONTOS_ADICIONAIS]  DEFAULT ((0)) FOR [QT_PONTOS_ADICIONAIS]
END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_PDV_PONTOS_FIDEL_IT_PDV_PONTOS_FIDEL_ID_CAB')
BEGIN
	ALTER TABLE [dbo].[PDV_PONTOS_FIDEL_IT]  WITH CHECK ADD CONSTRAINT FK_PDV_PONTOS_FIDEL_IT_PDV_PONTOS_FIDEL_ID_CAB FOREIGN KEY([ID_CAB])
	REFERENCES [dbo].[PDV_PONTOS_FIDEL] ([ID]) ON DELETE CASCADE
END
GO


